//field_demo.c
library "PToolboxLib"
include "Fctl.h"

//This example shows how to:
//1) install fields & GSI,
//2) make scroll rockers with repeat buttons,
//3) how to create a simple menu with a drop-down list,
//4) how to enable a "real" menu (uncomment line below)

//#define REAL_MENU //Uncomment this to enable a "real" palm menu

//Setup ID numbers (easier to manage for large projects)
#define FORM1  3000
#define BUTTON1 3001
#define ROCK1  3002
#define ROCK2  3003
#define LIST1  3004
#define FIELD1 3005
#define FIELD2 3006
#define FIELD3 3007

int repeat(int id) {
  switch(id) {
  case ROCK1:
    FsetText(ROCK2,"\x02");
  	if(Fctl(SCROLL,-1)) {
  		FsetText(ROCK1,"\x03");
  		return(-1);
  	}
   break;
  case ROCK2:
    FsetText(ROCK1,"\x01");
  	if(Fctl(SCROLL,1)) {
  	    FsetText(ROCK2,"\x04");
  		return(-1);
    }
    break;
  default: //handle field change
    if(Fctl(EXIST,id)) { //only update rockers if the field in this form
  	  FsetText(ROCK1,"\x01");
  	  FsetText(ROCK2,"\x02");
  	}
    break;
  }
  return(0);
}


main() {
int e,i;
string menu_items[6] = {"Cut","Copy","Paste","Select All","Keyboard","Graffiti Help"};

Fctl(REPEAT,repeat); //bind repeat handler function
clear();

Form(FORM1,"Field Demo");

//exit button
Button(BUTTON1,0,60,60,0,0,"EXIT");

//three fields
Field(FIELD1,0,100,20,50,36,64,"Field1!");
//FIELD2 is right aligned and is in single-line mode
Field(FIELD2,0x10001,100,70,32,FontHeight(),8,"Field2!");
Field(FIELD3,0,100,110,50,36,64,"Field3!\n1\n2\n3\n4\n5");
Fctl(SETINS,0); //set insertion point of last field to begging
Fctl(SETFOCUS,FIELD1); //set focus to first field

//menu list
List(LIST1,1,1,55,6,9999);
FsetList(LIST1,0,6,menu_items);

//Scroll Rockers
textattr(5,1,0); //change font
Button(ROCK1,0x35,70,118,13,8,"\x01");
Button(ROCK2,0x35,70,126,13,8,"\x02");
textattr(0,1,0); //restore font

//Grafitti Shift Indicator
GSI(150,150);

Fctl(DRAW,FORM1);

#ifdef REAL_MENU
Fctl(SETMENU,10000); //enable a PalmOS built-in menu
#else
Fctl(HOOKMENU,1); //Make Fevent trap menu events
#endif

//Keyboard support
Fctl(HOOKTAB,1); //tabs cycle through fields
//Fctl(HOOKLF,1); //line-feeds (returns) cycle through fields
Fctl(HOOKARROWS,1); //up-down keyboard arrows cycle through fields

while(1) {
 e=Fevent(1);
 switch(e) {
 case BUTTON1: return; 
 case 252: Fctl(PREVFIELD); break;
 case 253: Fctl(NEXTFIELD); break;
 case 11: //menu event
  i=Fctl(POPLIST,LIST1);
  switch(i) {
  case 0: Fctl(CUT); break;
  case 1: Fctl(COPY); break;
  case 2: Fctl(PASTE); break;
  case 3: Fctl(SELALL); break;
  case 4: Fctl(KEYBOARD,0); break;
  case 5: Fctl(GRAFFITI); break;
  }
  FsetState(LIST1,-1); //undo the list selection
 }	
}
}

